package ru.yandex.webmaster3.storage.robotstxt.model;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * User: baton
 * Date: 28.03.2007
 * Time: 18:45:21
 */
public enum SeverityEnum implements IntEnum {
    ERROR(50),
    WARNING(70),
    INFO(90),
    OK(110),
    SITE_ERROR(115),            // Ошибки сайта
    DISALLOWED_BY_USER(120),    // Запрещено к индексированию пользователем
    UNSUPPORTED_BY_ROBOT(125)   // Не поддерживается роботом
    ;

    private final int value;

    private SeverityEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<SeverityEnum> R = IntEnumResolver.r(SeverityEnum.class);
}
