package ru.yandex.webmaster3.storage.sanctions;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Set;

/**
 * Created by ifilippov5 on 23.08.17.
 */

public class SanctionsFilter {
    private final WebmasterHostId host;
    private final Long userId;
    private final Instant dateFrom;
    private final Instant dateTo;
    private final Set<String> sanctions;

    public SanctionsFilter(WebmasterHostId host, Long userId, Instant dateFrom, Instant dateTo, Set<String> sanctions) {
        this.host = host;
        this.userId = userId;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.sanctions = sanctions;
    }

    public WebmasterHostId getHost() {
        return host;
    }

    public Long getUserId() {
        return userId;
    }

    public Instant getDateFrom() {
        return dateFrom;
    }

    public Instant getDateTo() {
        return dateTo;
    }

    public Set<String> getSanctions() {
        return sanctions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WebmasterHostId host;
        private Long userId;
        private Instant dateFrom;
        private Instant dateTo;
        private Set<String> sanctions;

        public Builder host(WebmasterHostId hostId) {
            this.host = hostId;
            return this;
        }

        public Builder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public Builder dateFrom(Instant dateFrom) {
            this.dateFrom = dateFrom;
            return this;
        }

        public Builder dateTo(Instant dateTo) {
            this.dateTo = dateTo;
            return this;
        }

        public Builder dateFrom(DateTime dateFrom) {
            if (dateFrom == null) {
                this.dateFrom = null;
            } else {
                this.dateFrom = dateFrom.toInstant();
            }
            return this;
        }

        public Builder dateTo(DateTime dateTo) {
            if (dateTo == null) {
                this.dateTo = null;
            } else {
                this.dateTo = dateTo.toInstant();
            }
            return this;
        }

        public Builder sanctions(Set<String> sanctions) {
            this.sanctions = sanctions;
            return this;
        }

        public SanctionsFilter build() {
            return new SanctionsFilter(host, userId, dateFrom, dateTo, sanctions);
        }
    }
}

