package ru.yandex.webmaster3.storage.searchbase;

import org.joda.time.DateTime;
import org.joda.time.Instant;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class SearchBaseNotificationProgress {
    private final Instant searchBaseDate;
    private final DateTime startDate;
    private final DateTime endDate;
    private final int totalHosts;
    private final int processedHosts;
    private final WebmasterHostId lastHostId;

    public SearchBaseNotificationProgress(Instant searchBaseDate, DateTime startDate, DateTime endDate,
            int totalHosts, int processedHosts, WebmasterHostId lastHostId)
    {
        this.searchBaseDate = searchBaseDate;
        this.startDate = startDate;
        this.endDate = endDate;
        this.totalHosts = totalHosts;
        this.processedHosts = processedHosts;
        this.lastHostId = lastHostId;
    }

    public Instant getSearchBaseDate() {
        return searchBaseDate;
    }

    public DateTime getStartDate() {
        return startDate;
    }

    public DateTime getEndDate() {
        return endDate;
    }

    public int getTotalHosts() {
        return totalHosts;
    }

    public int getProcessedHosts() {
        return processedHosts;
    }

    public WebmasterHostId getLastHostId() {
        return lastHostId;
    }

    public SearchBaseNotificationProgress withTotal(int total) {
        return new SearchBaseNotificationProgress(searchBaseDate, startDate, endDate, total, processedHosts, lastHostId);
    }

    public SearchBaseNotificationProgress withProcessed(int processed) {
        return new SearchBaseNotificationProgress(searchBaseDate, startDate, endDate, totalHosts, processed, lastHostId);
    }

    public SearchBaseNotificationProgress withHost(WebmasterHostId hostId) {
        return new SearchBaseNotificationProgress(searchBaseDate, startDate, endDate, totalHosts, processedHosts + 1, hostId);
    }

    public SearchBaseNotificationProgress withEndDate(DateTime date) {
        return new SearchBaseNotificationProgress(searchBaseDate, startDate, date, totalHosts, processedHosts, lastHostId);
    }
}
