package ru.yandex.webmaster3.storage.searchbase;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import com.google.common.base.Suppliers;
import lombok.Setter;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.webmaster3.core.searchbase.SearchBaseDates;
import ru.yandex.webmaster3.storage.searchbase.dao.SearchBaseUpdatesYDao;

/**
 * @author avhaliullin
 */
public class SearchBaseUpdatesService {
    private static final Duration CACHE_TTL = Duration.standardMinutes(1);
    private final Supplier<SearchBaseDates> cache =
            Suppliers.memoizeWithExpiration(this::getDirectly, CACHE_TTL.getStandardSeconds(), TimeUnit.SECONDS);

    @Setter
    private SearchBaseUpdatesYDao searchBaseUpdatesYDao;

    private SearchBaseDates getDirectly() {
        return SearchBaseDates.fromBaseInfos(searchBaseUpdatesYDao.getUpdatesHistory().values());
    }

    public SearchBaseDates getSearchBaseUpdates() {
        // Выкидываем переключения, которые кто-то мог еще не видеть из-за кеша
        return cache.get().atMomentOfTime(Instant.now().minus(CACHE_TTL));
    }

}
