package ru.yandex.webmaster3.storage.searchbase.dao;

import java.util.List;

import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * ishalaru
 * 07.04.2021
 **/
@Repository
public class MonsterHostsYDao extends AbstractYDao {
    public MonsterHostsYDao() {
        super(PREFIX_WEBMASTER3, "monster_hosts");
    }

    public void insert(String host) {
        upsert(F.HOST_ID.value(IdUtils.urlToHostId(host))).execute();
    }

    public List<WebmasterHostId> selectAll() {
        return select(MAPPER).queryForList();
    }

    public static final DataMapper<WebmasterHostId> MAPPER = DataMapper.create(
            F.HOST_ID, e -> e
    );


    private static class F {
        static final Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
    }
}
