package ru.yandex.webmaster3.storage.searchquery;

import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum AggregatePeriod implements IntEnum {
    DAY(1, Days.ONE),
    WEEK(2, Weeks.ONE),
    MONTH(3, Months.ONE),
    ;

    private final int value;
    private final ReadablePeriod period;

    AggregatePeriod(int value, ReadablePeriod period) {
        this.value = value;
        this.period = period;
    }

    @Override
    public int value() {
        return value;
    }

    public ReadablePeriod getPeriod() {
        return period;
    }

    public static IntEnumResolver<AggregatePeriod> R = IntEnumResolver.r(AggregatePeriod.class);
}
