package ru.yandex.webmaster3.storage.searchquery;

import org.joda.time.LocalDate;

/**
 * @author aherman
 */
public class DayStat {
    protected LocalDate date;
    protected long totalShowsCount;
    protected long totalClicksCount;
    protected long showsCount_1;
    protected long clicksCount_1;
    protected long showsCount_2_3;
    protected long clicksCount_2_3;
    protected long showsCount_4_10;
    protected long clicksCount_4_10;
    protected long showsCount_11_50;
    protected long clicksCount_11_50;
    protected long aggrShowsCount_2_3;
    protected long aggrClicksCount_2_3;
    protected long aggrShowsCount_4_10;
    protected long aggrClicksCount_4_10;
    protected long aggrShowsCount_11_50;
    protected long aggrClicksCount_11_50;
    protected long totalSerpsCount;
    protected double weightedOwnerClicksCount;
    protected double weightedRivalsClicksCount;

    public DayStat(LocalDate date, long totalShowsCount, long totalClicksCount, long showsCount_1, long clicksCount_1, 
                   long showsCount_2_3, long clicksCount_2_3, long showsCount_4_10, long clicksCount_4_10, 
                   long showsCount_11_50, long clicksCount_11_50, long aggrShowsCount_2_3, long aggrClicksCount_2_3, 
                   long aggrShowsCount_4_10, long aggrClicksCount_4_10, long aggrShowsCount_11_50, 
                   long aggrClicksCount_11_50, long totalSerpsCount) {
        this.date = date;
        this.totalShowsCount = totalShowsCount;
        this.totalClicksCount = totalClicksCount;
        this.showsCount_1 = showsCount_1;
        this.clicksCount_1 = clicksCount_1;
        this.showsCount_2_3 = showsCount_2_3;
        this.clicksCount_2_3 = clicksCount_2_3;
        this.showsCount_4_10 = showsCount_4_10;
        this.clicksCount_4_10 = clicksCount_4_10;
        this.showsCount_11_50 = showsCount_11_50;
        this.clicksCount_11_50 = clicksCount_11_50;
        this.aggrShowsCount_2_3 = aggrShowsCount_2_3;
        this.aggrClicksCount_2_3 = aggrClicksCount_2_3;
        this.aggrShowsCount_4_10 = aggrShowsCount_4_10;
        this.aggrClicksCount_4_10 = aggrClicksCount_4_10;
        this.aggrShowsCount_11_50 = aggrShowsCount_11_50;
        this.aggrClicksCount_11_50 = aggrClicksCount_11_50;
        this.totalSerpsCount = totalSerpsCount;
    }

    public DayStat(LocalDate date, double weightedOwnerClicksCount, double weightedRivalsClicksCount) {
        this.date = date;
        this.weightedOwnerClicksCount = weightedOwnerClicksCount;
        this.weightedRivalsClicksCount = weightedRivalsClicksCount;
    }

    public LocalDate getDate() {
        return date;
    }

    public long getTotalShowsCount() {
        return totalShowsCount;
    }

    public long getTotalClicksCount() {
        return totalClicksCount;
    }

    public long getShowsCount_1() {
        return showsCount_1;
    }

    public long getClicksCount_1() {
        return clicksCount_1;
    }

    public long getShowsCount_2_3() {
        return showsCount_2_3;
    }

    public long getClicksCount_2_3() {
        return clicksCount_2_3;
    }

    public long getShowsCount_4_10() {
        return showsCount_4_10;
    }

    public long getClicksCount_4_10() {
        return clicksCount_4_10;
    }

    public long getShowsCount_11_50() {
        return showsCount_11_50;
    }

    public long getClicksCount_11_50() {
        return clicksCount_11_50;
    }

    public long getAggrShowsCount_2_3() {
        return aggrShowsCount_2_3;
    }

    public long getAggrClicksCount_2_3() {
        return aggrClicksCount_2_3;
    }

    public long getAggrShowsCount_4_10() {
        return aggrShowsCount_4_10;
    }

    public long getAggrClicksCount_4_10() {
        return aggrClicksCount_4_10;
    }

    public long getAggrShowsCount_11_50() {
        return aggrShowsCount_11_50;
    }

    public long getAggrClicksCount_11_50() {
        return aggrClicksCount_11_50;
    }

    public long getTotalSerpsCount() {
        return totalSerpsCount;
    }

    public double getWeightedOwnerClicksCount() {
        return weightedOwnerClicksCount;
    }

    public double getWeightedRivalsClicksCount() {
        return weightedRivalsClicksCount;
    }
}
