package ru.yandex.webmaster3.storage.searchquery;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.QueryBuilder;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.Statement;

import java.util.Arrays;

/**
 * Created by ifilippov5 on 04.04.17.
 */
public enum DeviceType implements IntEnum {
    ALL_DEVICES(0),
    MOBILE_AND_PAD(-1),
    MOBILE(1),
    DESKTOP(2),
    PAD(3),
    ;

    private final int value;

    DeviceType(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<DeviceType> R = IntEnumResolver.r(DeviceType.class);

    /**
     * Непонятно, куда пихать этот метод
     * @param deviceType
     * @return
     */
    public Statement getQueryFilter() {
        switch (this) {
            case ALL_DEVICES:
                return QueryBuilder.trueCondition();
            case MOBILE_AND_PAD:
                return QueryBuilder.in("device_type", Arrays.asList(MOBILE.value, PAD.value));
            default:
                return QueryBuilder.eq("device_type", value);
        }
    }
}
