package ru.yandex.webmaster3.storage.searchquery;

import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.searchquery.QueryGroupId;

/**
 * @author aherman
 */
public class GroupStat extends DayStat {
    private QueryGroupId groupId;

    public GroupStat(LocalDate date, QueryGroupId groupId, long totalShowsCount, long totalClicksCount,
            long showsCount_1,
            long clicksCount_1, long showsCount_2_3, long clicksCount_2_3, long showsCount_4_10,
            long clicksCount_4_10, long showsCount_11_50, long clicksCount_11_50, long aggrShowsCount_2_3,
            long aggrClicksCount_2_3, long aggrShowsCount_4_10, long aggrClicksCount_4_10,
            long aggrShowsCount_11_50, long aggrClicksCount_11_50, long totalSerpsCount)
    {
        super(date, totalShowsCount, totalClicksCount, showsCount_1, clicksCount_1, showsCount_2_3, clicksCount_2_3,
                showsCount_4_10, clicksCount_4_10, showsCount_11_50, clicksCount_11_50, aggrShowsCount_2_3, aggrClicksCount_2_3,
                aggrShowsCount_4_10, aggrClicksCount_4_10, aggrShowsCount_11_50, aggrClicksCount_11_50, totalSerpsCount);
        this.groupId = groupId;
    }

    public GroupStat(LocalDate date, QueryGroupId groupId, double weightedOwnerClicksCount, double weightedRivalsClicksCount) {
        super(date, weightedOwnerClicksCount, weightedRivalsClicksCount);
        this.groupId = groupId;
    }

    public QueryGroupId getGroupId() {
        return groupId;
    }

}
