package ru.yandex.webmaster3.storage.searchquery;

import java.util.List;
import java.util.Map;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.searchquery.LatestSearchQuery;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.core.searchquery.QueryFilter;
import ru.yandex.webmaster3.core.searchquery.QueryId;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.storage.searchquery.dao.QueriesWeekSmallCHDao;

/**
 * @author aherman
 */
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class LatestQueriesService {

    private final QueriesWeekSmallCHDao mdbQueriesWeekSmallCHDao;


    public long countQueriesByFilter(WebmasterHostId hostId, List<QueryFilter> filters) {
        return mdbQueriesWeekSmallCHDao.countQueries(hostId, filters);
    }

    public List<LatestSearchQuery> listQueriesByFilter(WebmasterHostId hostId, List<QueryFilter> filters, long from, long limit,
                                                       QueryIndicator orderBy, OrderDirection direction) {
        return mdbQueriesWeekSmallCHDao.listQueries(hostId, filters, orderBy, direction, from, limit);
    }

    public Map<QueryId, LatestSearchQuery> listQueriesByIds(WebmasterHostId hostId, List<QueryId> queryIds) {
        return mdbQueriesWeekSmallCHDao.getQueriesByIds(hostId, queryIds);
    }

    public Map<QueryId, String> getQueryTextsByIds(WebmasterHostId hostId, List<QueryId> ids) {
        return mdbQueriesWeekSmallCHDao.getQueryText(hostId, ids);
    }

    public long countUrlsByFilter(WebmasterHostId hostId, List<QueryFilter> filters) {
        return mdbQueriesWeekSmallCHDao.countUrls(hostId, filters);
    }

    public List<LatestSearchQuery> getUrlsByFilter(WebmasterHostId hostId, List<QueryFilter> filters, long from,
                                                   long limit, QueryIndicator orderBy, OrderDirection direction) {
        return mdbQueriesWeekSmallCHDao.listUrls(hostId, filters, orderBy, direction, from, limit);
    }
}
