package ru.yandex.webmaster3.storage.searchquery;

import java.util.regex.Pattern;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import static ru.yandex.webmaster3.storage.util.clickhouse2.AbstractClickhouseDao.DB_WEBMASTER3_QUERIES;

/**
 * Created by Oleg Bazdyrev on 05/06/2020.
 */
public interface SearchQueriesConstants {

    String TEMP_PREFIX = "tmp_";

    DateTimeFormatter IN_TABLE_NAME_DATE_FORMATTER = DateTimeFormat.forPattern("yyyyMMdd");
    DateTimeFormatter IN_TABLE_NAME_MONTH_FORMATTER = DateTimeFormat.forPattern("yyyyMM");

    String IN_TABLE_NAME_DATE_PATTERN = "\\d{8}";

    Pattern WEEK_NAME_PATTERN = Pattern.compile(DB_WEBMASTER3_QUERIES +
            ".week_" + IN_TABLE_NAME_DATE_PATTERN + "_(" + IN_TABLE_NAME_DATE_PATTERN + ")_small_distrib");
    Pattern TOP_URLS_NAME_PATTERN = Pattern.compile(DB_WEBMASTER3_QUERIES +
            ".top_urls_(" + IN_TABLE_NAME_DATE_PATTERN + ")_(queries|values)_distrib");
    Pattern TOP_QUERIES_NAME_PATTERN = Pattern.compile(DB_WEBMASTER3_QUERIES +
            ".top_(" + IN_TABLE_NAME_DATE_PATTERN + ")_(queries|values)_distrib");

    String FAVORITE_VALUES6 = "favorite_values7_";
    String GROUP_STATISTICS7 = "group_statistics8_";

    Pattern FAVORITE_VALUES_NAME_PATTERN = Pattern.compile(TEMP_PREFIX + FAVORITE_VALUES6 + "(" + IN_TABLE_NAME_DATE_PATTERN + ")_" + IN_TABLE_NAME_DATE_PATTERN);

    Pattern GROUP_STATISTICS_NAME_PATTERN = Pattern.compile(TEMP_PREFIX + GROUP_STATISTICS7 + "(" +IN_TABLE_NAME_DATE_PATTERN + ")");

}
