package ru.yandex.webmaster3.storage.searchquery;

import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author aherman
 */
public class StatisticDate {
    private final Type type;
    private final LocalDate date;

    public StatisticDate(Type type, LocalDate date) {
        this.type = type;
        this.date = date;
    }

    public Type getType() {
        return type;
    }

    public LocalDate getDate() {
        return date;
    }

    public static enum Type {
        MINIMUM_DATE,
        MAXIMUM_DATE,
        ;

        public static final EnumResolver<Type> R = EnumResolver.er(Type.class);
    }
}
