package ru.yandex.webmaster3.storage.searchquery.dao;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.FNVHash;
import ru.yandex.webmaster3.storage.searchquery.HostSearchQueryRegionInfo;
import ru.yandex.webmaster3.storage.util.clickhouse2.AbstractClickhouseDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseQueryContext;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.QueryBuilder;

/**
 * Created by Oleg Bazdyrev on 25/01/2021.
 */
@Repository
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class MdbHostSearchQueryRegionsCHDao extends AbstractClickhouseDao {

    private static final String TABLE_NAME = "host_regions";

    public List<HostSearchQueryRegionInfo> getRegionsForHost(WebmasterHostId hostId, LocalDate fromDate, LocalDate toDate) {
        var st = QueryBuilder.select("region_ids")
                .from(DB_WEBMASTER3_QUERIES, TABLE_NAME)
                .where(QueryBuilder.eq("host_id", hostId.toStringId()));

        var ctx = ClickhouseQueryContext.useDefaults().setHost(getClickhouseServer().pickAliveHostOrFail(getShard(hostId)));
        return getClickhouseServer().queryOne(ctx, st, row -> row.getIntListUnsafe(0)).orElse(Collections.emptyList()).stream()
                .map(regionId -> new HostSearchQueryRegionInfo(regionId, 1L)).collect(Collectors.toList());
    }

    protected int getShard(WebmasterHostId hostId) {
        int shards = getClickhouseServer().getShardsCount();
        return (int) (FNVHash.hash64Mod(hostId.toString(), shards));
    }
}
