package ru.yandex.webmaster3.storage.searchquery.dao;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.searchquery.MissingDataPeriod;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;

@Repository
public class MissingDataPeriodsYDao extends AbstractYDao {
    private static final String TABLE_NAME = "missing_data_periods";
    public MissingDataPeriodsYDao() {
        super(PREFIX_QUERIES, TABLE_NAME);
    }

    public List<MissingDataPeriod> getPeriods() {
        return select(MAPPER).queryForList();
    }

    private static final DataMapper<MissingDataPeriod> MAPPER = DataMapper.create(
            F.DATE_FROM,
            F.DATE_TO,
            F.REASON,
           MissingDataPeriod::new
    );

    private interface F {
        Field<DateTime> DATE_FROM = Fields.jodaDateTimeField("date_from");
        Field<DateTime> DATE_TO = Fields.jodaDateTimeField("date_to");
        Field<String> REASON = Fields.stringField("reason");
    }
}
