package ru.yandex.webmaster3.storage.searchquery.dao;

import java.util.Collections;
import java.util.List;

import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.searchquery.LatestSearchQuery;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.core.searchquery.QueryFilter;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.storage.clickhouse.LocalClickhouseTableProvider;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseException;

/**
 * @author aherman
 */
public class QueriesWeekSmallCHDao extends AbstractQueriesWeekCHDao {

    public long countQueries(WebmasterHostId hostId, List<QueryFilter> filters) {
        LocalClickhouseTableProvider table = getTableProvider();
        String queriesFilter = createFilteringQuery(table.getTableName(getClickhouseServer(), hostId), hostId, filters,
                null, null, Collections.emptyList(), true);
        String query =
                "SELECT count() AS count"
                + " FROM (" + queriesFilter + ")";
        return getClickhouseServer().queryOne(
                table.chContext(getClickhouseServer(), hostId), query, r -> r.getLongUnsafe("count")).orElse(0L);
    }

    public List<LatestSearchQuery> listQueries(WebmasterHostId hostId, List<QueryFilter> filters,
            QueryIndicator orderBy,
            OrderDirection direction, long from, long limit)
    {
        LocalClickhouseTableProvider table = getTableProvider();
        String query = createFilteringQuery(
                table.getTableName(getClickhouseServer(), hostId),
                hostId, filters,
                getOrder2(orderBy, direction) + "," + F.QUERY_ID + " ASC",
                from + "," + limit,
                Collections.emptyList(),
                true
        );

        return getClickhouseServer().queryAll(
                table.chContext(getClickhouseServer(), hostId), query, AbstractQueriesWeekCHDao::chRowToQueryWithQueryId);
    }

    public long countUrls(WebmasterHostId hostId, List<QueryFilter> filters) {
        LocalClickhouseTableProvider table = getTableProvider();
        String queriesFilter = createFilteringQuery(table.getTableName(getClickhouseServer(), hostId), hostId, filters,
                null, null, Collections.emptyList(), false);
        String query = "SELECT count() AS count FROM (" + queriesFilter + ")";
        return getClickhouseServer().queryOne(
                table.chContext(getClickhouseServer(), hostId), query, r -> r.getLongUnsafe("count")).orElse(0L);
    }

    public List<LatestSearchQuery> listUrls(WebmasterHostId hostId, List<QueryFilter> filters,
            QueryIndicator orderBy,
            OrderDirection direction, long from, long limit) throws ClickhouseException {
        LocalClickhouseTableProvider table = getTableProvider();
        String query = createFilteringQuery(
                table.getTableName(getClickhouseServer(), hostId),
                hostId, filters,
                getOrder2(orderBy, direction) + "," + F.URL + " ASC",
                from + "," + limit,
                Collections.emptyList(),
                false
        );

        return getClickhouseServer().queryAll(
                table.chContext(getClickhouseServer(), hostId), query, AbstractQueriesWeekCHDao::chRowToQueryWithUrl);
    }
}
