package ru.yandex.webmaster3.storage.searchquery.dao;

import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * ishalaru
 * 12.05.2021
 * Вставка в данную таблицу должна происходить из таски, т.к. это просто иморт из YT в YDB.
 **/
@Repository
public class QueryGroupLimitsYDao extends AbstractYDao {
    public QueryGroupLimitsYDao() {
        super(PREFIX_QUERIES, "query_group_limits");
    }

    public Integer getLimits(WebmasterHostId hostId, SpecialGroup specialGroup) {
        return select(LIMIT_DATA_MAPPER)
                .where(F.HOST_ID.eq(hostId))
                .and(F.QUERY_GROUP_TYPE.eq(specialGroup))
                .queryOne();
    }

    DataMapper<Integer> LIMIT_DATA_MAPPER = DataMapper.create(F.LIMIT, (e) -> e);

    private interface F {
        Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        Field<SpecialGroup> QUERY_GROUP_TYPE = Fields.intEnumField("group_type", SpecialGroup.INT_RESOLVER);
        Field<Integer> LIMIT = Fields.intField("limits").makeOptional();
    }
}
