package ru.yandex.webmaster3.storage.searchquery.dao;

import java.util.List;

import org.joda.time.LocalDate;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.searchquery.StatisticDate;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * @author aherman
 */
@Repository
public class StatisticDatesYDao extends AbstractYDao {
    private static final String TABLE_STATISTIC_DATES = "statistic_dates";
    private static final DataMapper<StatisticDate> MAPPER =
            DataMapper.create(F.TYPE, F.DATE, StatisticDate::new);

    public StatisticDatesYDao() {
        super(PREFIX_QUERIES, TABLE_STATISTIC_DATES);
    }

    public List<StatisticDate> getDates() {
        return select(MAPPER).queryForList();
    }

    public void update(StatisticDate sd) {
        upsert(
                F.TYPE.value(sd.getType()),
                F.DATE.value(sd.getDate())
        ).execute();
    }

    private interface F {
        Field<StatisticDate.Type> TYPE = Fields.stringEnumField("type", StatisticDate.Type.R);
        Field<LocalDate> DATE = Fields.jodaDateField("date");
    }
}
