package ru.yandex.webmaster3.storage.searchquery.dao;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.searchquery.Path;
import ru.yandex.webmaster3.core.searchquery.PathId;
import ru.yandex.webmaster3.core.util.URLEncodeUtil;
import ru.yandex.webmaster3.storage.clickhouse.LocalClickhouseTableProvider;
import ru.yandex.webmaster3.storage.clickhouse.TableProvider;
import ru.yandex.webmaster3.storage.clickhouse.TableType;
import ru.yandex.webmaster3.storage.clickhouse.table.TopUrlsTextsTable;
import ru.yandex.webmaster3.storage.util.clickhouse2.AbstractClickhouseDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseEscapeUtils;

/**
 * @author lester
 */
public class TopUrlsTextsCHDao extends AbstractClickhouseDao {

    @Setter
    private TableProvider tableStorage;
    @Setter
    private String partSuffix;

    protected String getPathIdsString(List<PathId> pathIds) {
        return pathIds.stream().map(l -> Long.toString(l.getValue())).collect(Collectors.joining(","));
    }

    protected LocalClickhouseTableProvider getTableProvider() {
        return new TopUrlsTextsTable(tableStorage.getTable(TableType.TOP_URLS_TEXTS), partSuffix);
    }

    public List<Path> suggestQueries(WebmasterHostId hostId, String pathPart, int limit) {
        LocalClickhouseTableProvider table = getTableProvider();
        String likeClause = "";
        if (!StringUtils.isEmpty(pathPart)) {
            likeClause = " AND path_text LIKE '%" + ClickhouseEscapeUtils.trimAndEscape(pathPart) + "%'";
        }

        String q = "SELECT path_id, path_text FROM " + table.getTableName(getClickhouseServer(), hostId)
                + " WHERE host_id='" + hostId.toStringId() + "' "
                + " " + likeClause
                + " LIMIT " + limit;

        return getClickhouseServer().queryAll(table.chContext(getClickhouseServer(), hostId), q, row -> {
            long pathId = row.getLongUnsafe("path_id");
            String pathText = row.getString("path_text");
            return new Path(hostId, new PathId(pathId), URLEncodeUtil.urlDecode(pathText));
        });
    }

    public List<Pair<PathId, String>> getPaths(WebmasterHostId hostId, List<PathId> pathIds) {
        if (pathIds.isEmpty()) {
            return Collections.emptyList();
        }
        LocalClickhouseTableProvider table = getTableProvider();
        String q = "SELECT distinct path_id, path_text FROM " + table.getTableName(getClickhouseServer(), hostId)
                + " WHERE host_id = '" + hostId.toStringId() + "'"
                + " AND path_id IN (" + getPathIdsString(pathIds) + ")";

        return getClickhouseServer().queryAll(table.chContext(getClickhouseServer(), hostId), q, row -> {
            long pathId = row.getLongUnsafe("path_id");
            String path = row.getString("path_text");

            return Pair.of(new PathId(pathId), URLEncodeUtil.urlDecode(path));
        });
    }
}
