package ru.yandex.webmaster3.storage.searchquery.importing;

import ru.yandex.webmaster3.storage.searchquery.SearchQueriesConstants;
import ru.yandex.webmaster3.storage.util.clickhouse2.AbstractClickhouseDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHPrimitiveType;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHTable;

/**
 * Created by Oleg Bazdyrev on 09/03/2021.
 */
public interface QueryTablesDefinitions {

    String PARTITIONS_BY = "cityHash64(host_id) % 128";

    CHTable TOP_QUERIES_VALUES_TABLE = CHTable.builder()
            .database(AbstractClickhouseDao.DB_WEBMASTER3_QUERIES)
            .name("top_%s_values")
            .partNameSuffix("_shard_")
            .parts(4)
            .partitionBy("toYYYYMM(date)")
            .keyField("date", CHPrimitiveType.Date)
            .keyField("host_id", CHPrimitiveType.String)
            .keyField("query_id", CHPrimitiveType.Int64)
            .keyField("region_id", CHPrimitiveType.Int32)
            .field("shows_total", CHPrimitiveType.Int64)
            .field("clicks_total", CHPrimitiveType.Int64)
            .field("shows_1", CHPrimitiveType.Int64)
            .field("clicks_1", CHPrimitiveType.Int64)
            .field("shows_2_3", CHPrimitiveType.Int64)
            .field("clicks_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_shows_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_2_3", CHPrimitiveType.Int64)
            .field("shows_4_10", CHPrimitiveType.Int64)
            .field("clicks_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_shows_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_4_10", CHPrimitiveType.Int64)
            .field("shows_11_50", CHPrimitiveType.Int64)
            .field("clicks_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_shows_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_11_50", CHPrimitiveType.Int64)
            .field("shows_1_50", CHPrimitiveType.Int64)
            .field("clicks_1_50", CHPrimitiveType.Int64)
            .field("agr_pos_shows_1_50", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_1_50", CHPrimitiveType.Int64)
            .field("serps_total", CHPrimitiveType.Int64)
            .field("device_type", CHPrimitiveType.Int8)
            .build();

    CHTable MDB_TOP_QUERIES_VALUES_TABLE = TOP_QUERIES_VALUES_TABLE.toBuilder()
            .partNameSuffix("_part_")
            .partitionBy(PARTITIONS_BY)
            .keyFields("host_id", "region_id", "query_id")
            .build();

    CHTable MDB_TOP_QUERIES_TEXTS_TABLE = CHTable.builder()
            .database(AbstractClickhouseDao.DB_WEBMASTER3_QUERIES)
            .name("top_%s_queries")
            .partitionBy(PARTITIONS_BY)
            .keyField("host_id", CHPrimitiveType.String)
            .keyField("query_id", CHPrimitiveType.Int64)
            .field("query_text", CHPrimitiveType.String)
            .build();

    CHTable TOP_URLS_VALUES_TABLE = CHTable.builder()
            .database(AbstractClickhouseDao.DB_WEBMASTER3_QUERIES)
            .name("top_urls_%s_values")
            .partNameSuffix("_shard_")
            .parts(4)
            .partitionBy("toYYYYMM(date)")
            .keyField("date", CHPrimitiveType.Date)
            .keyField("host_id", CHPrimitiveType.String)
            .keyField("path_id", CHPrimitiveType.Int64)
            .keyField("region_id", CHPrimitiveType.Int32)
            .field("shows_total", CHPrimitiveType.Int64)
            .field("clicks_total", CHPrimitiveType.Int64)
            .field("shows_1", CHPrimitiveType.Int64)
            .field("clicks_1", CHPrimitiveType.Int64)
            .field("shows_2_3", CHPrimitiveType.Int64)
            .field("clicks_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_shows_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_2_3", CHPrimitiveType.Int64)
            .field("shows_4_10", CHPrimitiveType.Int64)
            .field("clicks_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_shows_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_4_10", CHPrimitiveType.Int64)
            .field("shows_11_50", CHPrimitiveType.Int64)
            .field("clicks_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_shows_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_11_50", CHPrimitiveType.Int64)
            .field("shows_1_50", CHPrimitiveType.Int64)
            .field("clicks_1_50", CHPrimitiveType.Int64)
            .field("agr_pos_shows_1_50", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_1_50", CHPrimitiveType.Int64)
            .field("serps_total", CHPrimitiveType.Int64)
            .field("device_type", CHPrimitiveType.Int8)
            .build();

    CHTable MDB_TOP_URLS_VALUES_TABLE = TOP_URLS_VALUES_TABLE.toBuilder()
            .partNameSuffix("_part_")
            .partitionBy(PARTITIONS_BY)
            .keyFields("host_id", "region_id", "path_id")
            .build();

    CHTable MDB_TOP_URLS_TEXTS_TABLE = CHTable.builder()
            .database(AbstractClickhouseDao.DB_WEBMASTER3_QUERIES)
            .name("top_urls_%s_queries")
            .partitionBy(PARTITIONS_BY)
            .keyField("host_id", CHPrimitiveType.String)
            .keyField("path_id", CHPrimitiveType.Int64)
            .field("path_text", CHPrimitiveType.String)
            .build();

    CHTable MDB_WEEK_TABLE = CHTable.builder()
            .database(AbstractClickhouseDao.DB_WEBMASTER3_QUERIES)
            .name("week_%s_%s")
            .partNameSuffix("_part_")
            .parts(4)
            .partitionBy(PARTITIONS_BY)
            .keyField("host_id", CHPrimitiveType.String)
            .keyField("query_id", CHPrimitiveType.Int64)
            .field("query_text", CHPrimitiveType.String)
            .field("url", CHPrimitiveType.String)
            .field("shows_total", CHPrimitiveType.Int64)
            .field("clicks_total", CHPrimitiveType.Int64)
            .field("shows_1", CHPrimitiveType.Int64)
            .field("clicks_1", CHPrimitiveType.Int64)
            .field("shows_2_3", CHPrimitiveType.Int64)
            .field("clicks_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_show_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_click_2_3", CHPrimitiveType.Int64)
            .field("shows_4_10", CHPrimitiveType.Int64)
            .field("clicks_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_show_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_click_4_10", CHPrimitiveType.Int64)
            .field("shows_11_50", CHPrimitiveType.Int64)
            .field("clicks_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_show_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_click_11_50", CHPrimitiveType.Int64)
            .build();

    CHTable GROUPS_TABLE = CHTable.builder()
            .database(AbstractClickhouseDao.DB_WEBMASTER3_QUERIES)
            .name("%s" + SearchQueriesConstants.GROUP_STATISTICS7 + "%s")
            .partitionBy("toYYYYMM(date)")
            .keyField("date", CHPrimitiveType.Date)
            .keyField("host_id", CHPrimitiveType.String)
            .keyField("group_id", CHPrimitiveType.String)
            .keyField("region_id", CHPrimitiveType.Int32)
            .field("shows_total", CHPrimitiveType.Int64)
            .field("clicks_total", CHPrimitiveType.Int64)
            .field("shows_1", CHPrimitiveType.Int64)
            .field("clicks_1", CHPrimitiveType.Int64)
            .field("shows_2_3", CHPrimitiveType.Int64)
            .field("clicks_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_shows_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_2_3", CHPrimitiveType.Int64)
            .field("shows_4_10", CHPrimitiveType.Int64)
            .field("clicks_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_shows_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_4_10", CHPrimitiveType.Int64)
            .field("shows_11_50", CHPrimitiveType.Int64)
            .field("clicks_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_shows_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_11_50", CHPrimitiveType.Int64)
            .field("serps_total", CHPrimitiveType.Int64)
            .field("device_type", CHPrimitiveType.Int8)
            .build();

    CHTable MDB_GROUPS_TABLE = GROUPS_TABLE.toBuilder()
            .name("%sgroup_statistics_%s")
            .partitionBy("toYYYYMM(date)")
            .keyFields("host_id", "region_id", "group_id")
            .build();

    CHTable FAVORITE_VALUES_TABLE = CHTable.builder()
            .database(AbstractClickhouseDao.DB_WEBMASTER3_QUERIES)
            .name("%s" + SearchQueriesConstants.FAVORITE_VALUES6 + "%s_%s")
            .partitionBy("toYYYYMM(date)")
            .keyField("date", CHPrimitiveType.Date)
            .keyField("host_id", CHPrimitiveType.String)
            .keyField("query_id", CHPrimitiveType.Int64)
            .keyField("region_id", CHPrimitiveType.Int32)
            .field("shows_total", CHPrimitiveType.Int64)
            .field("clicks_total", CHPrimitiveType.Int64)
            .field("shows_1", CHPrimitiveType.Int64)
            .field("clicks_1", CHPrimitiveType.Int64)
            .field("shows_2_3", CHPrimitiveType.Int64)
            .field("clicks_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_shows_2_3", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_2_3", CHPrimitiveType.Int64)
            .field("shows_4_10", CHPrimitiveType.Int64)
            .field("clicks_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_shows_4_10", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_4_10", CHPrimitiveType.Int64)
            .field("shows_11_50", CHPrimitiveType.Int64)
            .field("clicks_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_shows_11_50", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_11_50", CHPrimitiveType.Int64)
            .field("shows_1_50", CHPrimitiveType.Int64)
            .field("clicks_1_50", CHPrimitiveType.Int64)
            .field("agr_pos_shows_1_50", CHPrimitiveType.Int64)
            .field("agr_pos_clicks_1_50", CHPrimitiveType.Int64)
            .field("serps_total", CHPrimitiveType.Int64)
            .field("device_type", CHPrimitiveType.Int8)
            .build();

    CHTable MDB_FAVORITE_VALUES_TABLE = FAVORITE_VALUES_TABLE.toBuilder()
            .name("%sfavorite_values_%s_%s")
            .partitionBy("toYYYYMM(date)")
            .keyFields("host_id", "region_id", "query_id")
            .build();

}
