package ru.yandex.webmaster3.storage.searchquery.importing.dao;

import java.util.List;
import java.util.UUID;

import com.google.common.base.Preconditions;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.RowMapper;
import ru.yandex.webmaster3.storage.util.yt.YtPath;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadState;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;

/**
 * Created by Oleg Bazdyrev on 10/04/2017.
 */
@Repository
public class YtClickhouseDataLoadYDao extends AbstractYDao implements YtClickhouseDataLoadRepository {

    private static final String TABLE_NAME = "yt_clickhouse_data_load";

    public YtClickhouseDataLoadYDao() {
        super(PREFIX_IMPORTER, TABLE_NAME);
    }

    public YtClickhouseDataLoad load(YtClickhouseDataLoadType type) {
        return select(MAPPER).where(F.TYPE.eq(type)).queryOne();
    }

    public List<YtClickhouseDataLoad> listAll() {
        return select(MAPPER).queryForList();
    }

    public void save(YtClickhouseDataLoad data) {
        Preconditions.checkArgument(data != null);
        upsert(
                F.TYPE.value(data.getType()),
                F.STATE.value(data.getState()),
                F.DATE_FROM.value(data.getDateFrom()),
                F.DATE_TO.value(data.getDateTo()),
                F.LAST_UPDATED.value(data.getLastUpdated()),
                F.LAST_SUCCESS.value(data.getLastSuccess()),
                F.DATA.value(data.getData()),
                F.YT_SOURCE_TABLE.value(data.getSourceTable()),
                F.YT_PREPARED_TABLES.value(data.getPreparedTables()),
                F.IMPORT_TASK_IDS.value(data.getImportTaskIds()),
                F.REPLICATION_TASK_IDS.value(data.getReplicationTaskIds())
        ).execute();
    }

    private static final RowMapper<YtClickhouseDataLoad> MAPPER =
            DataMapper.create(F.TYPE, F.STATE, F.DATE_FROM, F.DATE_TO, F.LAST_UPDATED, F.LAST_SUCCESS, F.DATA, F.YT_SOURCE_TABLE,
                F.YT_PREPARED_TABLES, F.IMPORT_TASK_IDS, F.REPLICATION_TASK_IDS, YtClickhouseDataLoad::new);

    private interface F {
        Field<YtClickhouseDataLoadType> TYPE = Fields.stringEnumField("type", YtClickhouseDataLoadType.R);
        Field<YtClickhouseDataLoadState> STATE = Fields.stringEnumField("state", YtClickhouseDataLoadState.R);
        Field<LocalDate> DATE_FROM = Fields.jodaDateField("date_from").makeOptional();
        Field<LocalDate> DATE_TO = Fields.jodaDateField("date_to").makeOptional();
        Field<Instant> LAST_UPDATED = Fields.jodaInstantField("last_updated");
        Field<Instant> LAST_SUCCESS = Fields.jodaInstantField("last_success").makeOptional();
        Field<String> DATA = Fields.stringField("data").makeOptional();
        Field<YtPath> YT_SOURCE_TABLE = Fields.ytPathField("yt_source_table").makeOptional();
        Field<List<YtPath>> YT_PREPARED_TABLES = Fields.jsonField2("yt_prepared_tables", Fields.YT_PATH_LIST_REFERENCE).makeOptional();
        Field<List<UUID>> IMPORT_TASK_IDS = Fields.jsonField2("import_task_ids", Fields.UUID_LIST_REFERENCE).makeOptional();
        Field<List<UUID>> REPLICATION_TASK_IDS = Fields.jsonField2("replication_task_ids", Fields.UUID_LIST_REFERENCE).makeOptional();
    }
}
