package ru.yandex.webmaster3.storage.searchquery.rivals;

import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;


/**
 * Created by Oleg Bazdyrev on 08/11/2017.
 */
public class RivalsStats {

    private final LocalDate date;
    private final WebmasterHostId hostId;
    private final DeviceType deviceType;
    private final long rivalsCount;
    private final double ctr;
    private final double shows;
    private final double clicks;
    private final long totalShows;
    private final long totalClicks;

    public RivalsStats(LocalDate date, WebmasterHostId hostId, DeviceType deviceType, long rivalsCount, double ctr,
                       double shows, double clicks, long totalShows, long totalClicks) {
        this.date = date;
        this.hostId = hostId;
        this.deviceType = deviceType;
        this.rivalsCount = rivalsCount;
        this.ctr = ctr;
        this.shows = shows;
        this.clicks = clicks;
        this.totalShows = totalShows;
        this.totalClicks = totalClicks;
    }

    public LocalDate getDate() {
        return date;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public DeviceType getDeviceType() {
        return deviceType;
    }

    public long getRivalsCount() {
        return rivalsCount;
    }

    public double getCtr() {
        return ctr;
    }

    public double getShows() {
        return shows;
    }

    public double getClicks() {
        return clicks;
    }

    public long getTotalShows() {
        return totalShows;
    }

    public long getTotalClicks() {
        return totalClicks;
    }
}
