package ru.yandex.webmaster3.storage.searchquery.rivals;

import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;


/**
 * Created by Oleg Bazdyrev on 08/11/2017.
 */
public class RivalsStats2 {

    private final LocalDate date;
    private final String thematics;
    private final DeviceType deviceType;
    private final String type;
    private final double ctr;
    private final long shows;
    private final long clicks;
    private final long domains;

    public RivalsStats2(LocalDate date, String thematics, DeviceType deviceType, String type, double ctr, long shows, long clicks, long domains) {
        this.date = date;
        this.thematics = thematics;
        this.deviceType = deviceType;
        this.type = type;
        this.ctr = ctr;
        this.shows = shows;
        this.clicks = clicks;
        this.domains = domains;
    }

    public LocalDate getDate() {
        return date;
    }

    public String getThematics() {
        return thematics;
    }

    public DeviceType getDeviceType() {
        return deviceType;
    }

    public String getType() {
        return type;
    }

    public double getCtr() {
        return ctr;
    }

    public long getShows() {
        return shows;
    }

    public long getClicks() {
        return clicks;
    }

    public long getDomains() {
        return domains;
    }
}
