package ru.yandex.webmaster3.storage.searchquery.util;

import java.util.function.Function;

import ru.yandex.webmaster3.storage.searchquery.DayStat;

/**
 * @author aherman
 */
public class CtrAccumulator implements Accumulator {
    private long clicks;
    private long shows;

    private final Function<DayStat, Long> clickExtractor;
    private final Function<DayStat, Long> showsExtractor;

    public CtrAccumulator(Function<DayStat, Long> clickExtractor, Function<DayStat, Long> showsExtractor) {
        this.clickExtractor = clickExtractor;
        this.showsExtractor = showsExtractor;
    }

    @SuppressWarnings("Duplicates")
    @Override
    public Void apply(DayStat stat) {
        Long c = clickExtractor.apply(stat);
        Long s = showsExtractor.apply(stat);
        if (c == null && s == null) {
            return null;
        }
        if (c != null) {
            clicks += c;
        }
        if (s != null) {
            shows += s;
        }
        return null;
    }

    @Override
    public Double getValue() {
        if (clicks == 0 && shows == 0) {
            return null;
        }

        if (shows > 0) {
            return clicks * 1.0 / shows;
        }

        return (double) clicks;
    }

    @Override
    public String toString() {
        return "CTR[" + clicks + "/" + shows + "]";
    }
}
