package ru.yandex.webmaster3.storage.searchquery.util;

import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.storage.searchquery.DayStat;

/**
 * @author aherman
 */
public class ExtractorFactory {
    public static Accumulator createExtractor(QueryIndicator indicator) {
        switch (indicator) {
            case CLICKS_1_50:
            case TOTAL_CLICKS_COUNT:
                return new SumAccumulator(DayStat::getTotalClicksCount);
            case SHOWS_1_50:
            case TOTAL_SHOWS_COUNT:
                return new SumAccumulator(DayStat::getTotalShowsCount);
            case TOTAL_SERPS_COUNT:
                return new SumAccumulator(DayStat::getTotalSerpsCount);
            case CLICKS_COUNT_1:
                return new SumAccumulator(DayStat::getClicksCount_1);
            case CLICKS_COUNT_2_3:
                return new SumAccumulator(DayStat::getClicksCount_2_3);
            case CLICKS_COUNT_4_10:
                return new SumAccumulator(DayStat::getClicksCount_4_10);
            case CLICKS_COUNT_11_50:
                return new SumAccumulator(DayStat::getClicksCount_11_50);
            case SHOWS_COUNT_1:
                return new SumAccumulator(DayStat::getShowsCount_1);
            case SHOWS_COUNT_2_3:
                return new SumAccumulator(DayStat::getShowsCount_2_3);
            case SHOWS_COUNT_4_10:
                return new SumAccumulator(DayStat::getShowsCount_4_10);
            case SHOWS_COUNT_11_50:
                return new SumAccumulator(DayStat::getShowsCount_11_50);
            case AVERAGE_SHOW_POSITION_2_3:
                return new WeightedAvgPositionAccumulator(DayStat::getShowsCount_2_3, DayStat::getAggrShowsCount_2_3);
            case AVERAGE_SHOW_POSITION_4_10:
                return new WeightedAvgPositionAccumulator(DayStat::getShowsCount_4_10, DayStat::getAggrShowsCount_4_10);
            case AVERAGE_SHOW_POSITION_11_50:
                return new WeightedAvgPositionAccumulator(DayStat::getShowsCount_11_50, DayStat::getAggrShowsCount_11_50);
            case AVERAGE_CLICK_POSITION_2_3:
                return new WeightedAvgPositionAccumulator(DayStat::getClicksCount_2_3, DayStat::getAggrClicksCount_2_3);
            case AVERAGE_CLICK_POSITION_4_10:
                return new WeightedAvgPositionAccumulator(DayStat::getClicksCount_4_10, DayStat::getAggrClicksCount_4_10);
            case AVERAGE_CLICK_POSITION_11_50:
                return new WeightedAvgPositionAccumulator(DayStat::getClicksCount_11_50, DayStat::getAggrClicksCount_11_50);

            case AVERAGE_SHOW_POSITION:
                return new WeightedAvgPositionAccumulator(
                        d -> d.getTotalShowsCount(),
                        d -> d.getShowsCount_1() + d.getAggrShowsCount_2_3() + d.getAggrShowsCount_4_10() + d.getAggrShowsCount_11_50()
                        );

            case AVERAGE_CLICK_POSITION:
                return new WeightedAvgPositionAccumulator(
                        d -> d.getTotalClicksCount(),
                        d -> d.getClicksCount_1() + d.getAggrClicksCount_2_3() + d.getAggrClicksCount_4_10() + d.getAggrClicksCount_11_50()
                );

            case CTR_1:
                return new CtrAccumulator(DayStat::getClicksCount_1, DayStat::getShowsCount_1);
            case CTR_2_3:
                return new CtrAccumulator(DayStat::getClicksCount_2_3, DayStat::getShowsCount_2_3);
            case CTR_4_10:
                return new CtrAccumulator(DayStat::getClicksCount_4_10, DayStat::getShowsCount_4_10);
            case CTR_11_50:
                return new CtrAccumulator(DayStat::getClicksCount_11_50, DayStat::getShowsCount_11_50);
            case TOTAL_CTR:
                return new CtrAccumulator(DayStat::getTotalClicksCount, DayStat::getTotalShowsCount);
            case WEIGHTED_CLICKS:
                return new DoubleSumAccumulator(DayStat::getWeightedOwnerClicksCount);
            case WEIGHTED_RIVALS_CLICKS:
                return new DoubleSumAccumulator(DayStat::getWeightedRivalsClicksCount);
            default:
                return new SumAccumulator(d -> null);
        }
    }
}
