package ru.yandex.webmaster3.storage.searchquery.util;

import java.util.function.Function;

import ru.yandex.webmaster3.storage.searchquery.DayStat;

/**
 * @author aherman
 */
public class SumAccumulator implements Function<DayStat, Void>, Accumulator {
    private final Function<DayStat, Long> valueExtractor;
    private long sum = 0;

    public SumAccumulator(Function<DayStat, Long> valueExtractor) {
        this.valueExtractor = valueExtractor;
    }

    @Override
    public Void apply(DayStat stat) {
        Long v = valueExtractor.apply(stat);
        if (v == null) {
            return null;
        }

        sum += v;
        return null;
    }

    @Override
    public Double getValue() {
        return (double) sum;
    }

    @Override
    public String toString() {
        return "SUM[" + sum + "]";
    }
}
