package ru.yandex.webmaster3.storage.searchurl.download;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.opencsv.bean.CsvBindByName;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;

/**
 * Created by ifilippov5 on 16.02.17.
 */
@Row(colsOrder = {"lastAccess", "title", "url", "httpCode", "status", "target", "fromSitemap"})
public class ExcludedUrlCsvRow {
    //Ограничение для выгрузки в excell. По таске WMCSUPPORT-3320
    private static final int MAX_TITLE_SIZE = 31000;
    @CsvBindByName
    @Column
    private final String lastAccess;

    @CsvBindByName
    @Column
    private final String title;

    @CsvBindByName
    @Column
    private final String url;

    @CsvBindByName
    @Column
    private final String httpCode;

    @CsvBindByName
    @Column
    private final String status;

    @CsvBindByName
    @Column
    private final String target;

    @CsvBindByName
    @Column
    private final String fromSitemap;

    public ExcludedUrlCsvRow(@JsonProperty("lastAccess") String lastAccess,
                             @JsonProperty("title") String title,
                             @JsonProperty("url") String url,
                             @JsonProperty("httpCode") String httpCode,
                             @JsonProperty("status") String status,
                             @JsonProperty("target") String target,
                             @JsonProperty("fromSitemap") String fromSitemap) {
        this.url = url;
        this.lastAccess = lastAccess;
        this.title = title == null || title.length() < MAX_TITLE_SIZE ? title : title.substring(0,MAX_TITLE_SIZE);
        this.httpCode = httpCode;
        this.status = status;
        this.target = target;
        this.fromSitemap = fromSitemap;
    }

    @Description("дата последнего посещения страницы")
    public String getLastAccess() {
        return lastAccess;
    }

    @Description("адрес страницы")
    public String getUrl() {
        return url;
    }

    @Description("заголовок страницы")
    public String getTitle() {
        return title;
    }

    public String getHttpCode() {
        return httpCode;
    }

    public String getTarget() {
        return target;
    }

    @Description("информация о статусе исключенной страницы")
    public String getStatus() {
        return status;
    }

    public String getFromSitemap() {
        return fromSitemap;
    }

}
