package ru.yandex.webmaster3.storage.searchurl.download;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.opencsv.bean.CsvBindByName;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;

/**
 * Created by ifilippov5 on 16.02.17.
 */
@Row(colsOrder = {"url", "lastAccess", "title", "fromSitemap"})
public class SearchUrlCsvRow {
    //Ограничение для выгрузки в excell. По таске WMCSUPPORT-3320
    private static final int MAX_TITLE_SIZE = 31000;
    @CsvBindByName
    @Column
    private final String url;
    @CsvBindByName
    @Column
    private final String lastAccess;
    @CsvBindByName
    @Column
    private final String title;
    @CsvBindByName
    @Column
    private final String fromSitemap;


    public SearchUrlCsvRow(@JsonProperty("url") String url,
                           @JsonProperty("lastAccess") String lastAccess,
                           @JsonProperty("title") String title,
                           @JsonProperty("fromSitemap") String fromSitemap) {
        this.url = url;
        this.title = title == null || title.length() < MAX_TITLE_SIZE ? title : title.substring(0,MAX_TITLE_SIZE);
        this.lastAccess = lastAccess;
        this.fromSitemap = fromSitemap;
    }

    @Description("адрес страницы")
    public String getUrl() {
        return url;
    }

    @Description("дата последнего посещения страницы")
    public String getLastAccess() {
        return lastAccess;
    }

    @Description("заголовок страницы")
    public String getTitle() {
        return title;
    }

    public String getFromSitemap() {
        return fromSitemap;
    }
}
