package ru.yandex.webmaster3.storage.searchurl.history;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.SearchUrlFreshStatisticsCHDao;

/**
 * ishalaru
 * 17.03.2021
 **/
@Slf4j
@Component
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class SearchUrlFreshHistoryService {
    private final SearchUrlFreshStatisticsCHDao searchUrlFreshStatisticsCHDao;

    public List<SearchUrlFreshStatisticsCHDao.Record> loadFreshCount(WebmasterHostId hostId, Instant fromDate, Instant toDate) {
        return searchUrlFreshStatisticsCHDao
                .loadCountInfo(hostId, fromDate, toDate);
    }

}
