package ru.yandex.webmaster3.storage.searchurl.history;

import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.proto.Links;


/**
 * @author avhaliullin
 */
public class SearchUrlHistoryTableUtil {
    public static final String SEARCH_URL_PART_TABLE_NAME_PREFIX = "search_urls_count_history_part_";
    public static final String EXCLUDED_URL_PART_TABLE_NAME_PREFIX = "excluded_urls_count_history_part_";

    private static final String SEARCH_URL_PART_TABLE_NAME_FORMAT = SEARCH_URL_PART_TABLE_NAME_PREFIX + "%s_%s";
    private static final String SEARCH_URL_TMP_PART_TABLE_NAME_FORMAT = "tmp_search_urls_count_history_part_%s_%s";
    private static final String EXCLUDED_URL_PART_TABLE_NAME_FORMAT = EXCLUDED_URL_PART_TABLE_NAME_PREFIX + "%s_%s";
    private static final String EXCLUDED_URL_TMP_PART_TABLE_NAME_FORMAT = "tmp_excluded_urls_count_history_part_%s_%s";
    private static final DateTimeFormatter FORMATTER = TimeUtils.DF_YYYYMMDDHHMMSS_WRITE;
    private static final DateTimeFormatter OLD_FORMATTER = TimeUtils.DF_YYYYMMDD;

    public static String getSearchUrlTableName(LocalDateTime from, LocalDateTime to, boolean oldFormat) {
        return String.format(
                SEARCH_URL_PART_TABLE_NAME_FORMAT,
                from.toString(oldFormat ? OLD_FORMATTER : FORMATTER),
                to.toString(oldFormat ? OLD_FORMATTER : FORMATTER)
        );
    }

    public static String getSearchUrlTmpTableName(LocalDateTime from, LocalDateTime to, boolean oldFormat) {
        return String.format(
                SEARCH_URL_TMP_PART_TABLE_NAME_FORMAT,
                from.toString(oldFormat ? OLD_FORMATTER : FORMATTER),
                to.toString(oldFormat ? OLD_FORMATTER : FORMATTER)
        );
    }

    public static String getExcludedUrlTableName(LocalDateTime from, LocalDateTime to, boolean oldFormat) {
        return String.format(
                EXCLUDED_URL_PART_TABLE_NAME_FORMAT,
                from.toString(oldFormat ? OLD_FORMATTER : FORMATTER),
                to.toString(oldFormat ? OLD_FORMATTER : FORMATTER)
        );
    }

    public static String getExcludedUrlTmpTableName(LocalDateTime from, LocalDateTime to, boolean oldFormat) {
        return String.format(
                EXCLUDED_URL_TMP_PART_TABLE_NAME_FORMAT,
                from.toString(oldFormat ? OLD_FORMATTER : FORMATTER),
                to.toString(oldFormat ? OLD_FORMATTER : FORMATTER)
        );
    }

}
