package ru.yandex.webmaster3.storage.searchurl.history.data;

import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;

import java.util.EnumMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class ExcludedUrlHistoryPoint {
    private final Map<SearchUrlStatusEnum, Long> status2Value;

    public ExcludedUrlHistoryPoint(Map<SearchUrlStatusEnum, Long> status2Value) {
        this.status2Value = status2Value;
    }

    public Map<SearchUrlStatusEnum, Long> getStatus2Value() {
        return status2Value;
    }

    private static final Map<SearchUrlStatusEnum, SearchUrlStatusEnum> REMAP_RULES = new EnumMap<>(SearchUrlStatusEnum.class);
    static {
        REMAP_RULES.put(SearchUrlStatusEnum.INDEXED_NOTSEARCHABLE, SearchUrlStatusEnum.SEMIDUP);
    }

    /**
     * WMC-3770 - merging INDEXED_NOT_SEARCHABLE to SEMIDUP.
     * OTHER is no longer merged, see WMC-7202
     */
    public ExcludedUrlHistoryPoint mergeStatuses() {
        boolean needMerge = false;
        for (SearchUrlStatusEnum toRemap : REMAP_RULES.keySet()) {
            if (status2Value.containsKey(toRemap)) {
                needMerge = true;
                break;
            }
        }
        if (!needMerge) {
            return this;
        }
        Map<SearchUrlStatusEnum, Long> newMap = new EnumMap<>(SearchUrlStatusEnum.class);
        for (Map.Entry<SearchUrlStatusEnum, Long> entry : status2Value.entrySet()) {
            SearchUrlStatusEnum origStatus = entry.getKey();
            SearchUrlStatusEnum status = REMAP_RULES.getOrDefault(origStatus, origStatus);
            newMap.merge(status, entry.getValue(), Long::sum);
        }

        return new ExcludedUrlHistoryPoint(newMap);
    }
}
