package ru.yandex.webmaster3.storage.searchurl.history.data;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;

/**
 * @author avhaliullin
 */
public class ExcludedUrlHistoryRecord {
    private final WebmasterHostId hostId;
    private final SearchUrlStatusEnum status;
    private final long nodeId;
    private final Instant timestamp;
    private final long value;

    public ExcludedUrlHistoryRecord(WebmasterHostId hostId, SearchUrlStatusEnum status, long nodeId, Instant timestamp, long value) {
        this.hostId = hostId;
        this.status = status;
        this.nodeId = nodeId;
        this.timestamp = timestamp;
        this.value = value;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public SearchUrlStatusEnum getStatus() {
        return status;
    }

    public long getNodeId() {
        return nodeId;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public long getValue() {
        return value;
    }
}
