package ru.yandex.webmaster3.storage.searchurl.history.data;

import java.util.Collections;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class SearchUrlHistoryPoint {
    /**
     * Вложенная мапа отображает индикатор в его значение.
     * Внешняя мапа группирует все значения по node id.
     */
    private final Map<Long, Map<SearchUrlHistoryIndicator, Long>> node2Values;

    public SearchUrlHistoryPoint(Map<Long, Map<SearchUrlHistoryIndicator, Long>> node2Values) {
        this.node2Values = node2Values;
    }

    public Map<Long, Map<SearchUrlHistoryIndicator, Long>> getNode2Values() {
        return node2Values;
    }

    public long getValue(SearchUrlHistoryIndicator indicator, long nodeId) {
        return node2Values
                .getOrDefault(nodeId, Collections.emptyMap())
                .getOrDefault(indicator, 0L);
    }
}
