package ru.yandex.webmaster3.storage.searchurl.history.data;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class SearchUrlHistoryRecord {
    private final WebmasterHostId hostId;
    private final SearchUrlHistoryIndicator indicator;
    private final long nodeId;
    private final Instant timestamp;
    private final long value;

    public SearchUrlHistoryRecord(WebmasterHostId hostId, SearchUrlHistoryIndicator indicator, long nodeId, Instant timestamp, long value) {
        this.hostId = hostId;
        this.indicator = indicator;
        this.nodeId = nodeId;
        this.timestamp = timestamp;
        this.value = value;
    }

    public SearchUrlHistoryIndicator getIndicator() {
        return indicator;
    }

    public long getNodeId() {
        return nodeId;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public long getValue() {
        return value;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }
}
