package ru.yandex.webmaster3.storage.searchurl.history.data;

import com.google.common.base.MoreObjects;
import org.joda.time.Instant;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class SearchUrlStat {
    private final WebmasterHostId hostId;
    private final Instant baseCollectionDate;
    private final long totalPages;
    private final long newPages;
    private final long gonePages;

    public SearchUrlStat(WebmasterHostId hostId, Instant baseCollectionDate, long totalPages, long newPages,
            long gonePages)
    {
        this.hostId = hostId;
        this.baseCollectionDate = baseCollectionDate;
        this.totalPages = totalPages;
        this.newPages = newPages;
        this.gonePages = gonePages;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public Instant getBaseCollectionDate() {
        return baseCollectionDate;
    }

    public long getTotalPages() {
        return totalPages;
    }

    public long getNewPages() {
        return newPages;
    }

    public long getGonePages() {
        return gonePages;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("hostId", hostId)
                .add("baseCollectionDate", baseCollectionDate)
                .add("totalPages", totalPages)
                .add("newPages", newPages)
                .add("gonePages", gonePages)
                .toString();
    }
}
