package ru.yandex.webmaster3.storage.searchurl.offline.dao;

import java.util.List;

import org.joda.time.Instant;

import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportInfo;
import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportTaskType;

/**
 * Created by Oleg Bazdyrev on 02/03/2021.
 */
public interface SearchBaseImportTablesRepository {

    void insertStage(SearchBaseImportInfo info);

    void updateTaskPaused(SearchBaseImportTaskType taskType, Instant baseDate, boolean paused);

    List<SearchBaseImportInfo> listAllTasks();

    List<SearchBaseImportInfo> listBases(SearchBaseImportTaskType taskType);

    SearchBaseImportInfo getBaseInfo(SearchBaseImportTaskType taskType, Instant baseDate);

    SearchBaseImportInfo getLatestBaseInfo(SearchBaseImportTaskType taskType);
}
