package ru.yandex.webmaster3.storage.searchurl.offline.dao;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.searchbase.SearchBaseUpdateInfo;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTable;
import ru.yandex.webmaster3.storage.clickhouse.TableType;
import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportTaskType;

/**
 * @author avhaliullin
 */
public class SearchBaseImportedTable implements ClickhouseTable {
    private final SearchBaseImportTaskType taskType;
    private final String dbName;
    private final String readTableName;
    private final SearchBaseUpdateInfo baseUpdateInfo;
    private final int shardCount;
    private final int partCount;

    public SearchBaseImportedTable(SearchBaseImportTaskType taskType, String dbName, String readTableName, SearchBaseUpdateInfo baseUpdateInfo,
                                   int shardCount, int partCount) {
        this.taskType = taskType;
        this.dbName = dbName;
        this.readTableName = readTableName;
        this.baseUpdateInfo = baseUpdateInfo;
        this.shardCount = shardCount;
        this.partCount = partCount;
    }

    public SearchBaseUpdateInfo getBaseUpdateInfo() {
        return baseUpdateInfo;
    }

    public SearchBaseImportTaskType getTaskType() {
        return taskType;
    }

    public String getDbName() {
        return dbName;
    }

    public String getReadTableName() {
        return readTableName;
    }

    public String getFullTableName() {
        return dbName + "." + readTableName;
    }

    @Override
    public TableType getType() {
        return null;
    }

    @Override
    public DateTime getUpdateDate() {
        return null;
    }

    @Override
    public String getClickhouseFullName() {
        return getFullTableName();
    }

    @Override
    public String getDistributedTableName() {
        return getFullTableName();
    }

    @Override
    public String getLocalTableName() {
        return null;
    }

    @Override
    public int getShardCount() {
        return shardCount;
    }

    @Override
    public int getPartCount() {
        return partCount;
    }
}
