package ru.yandex.webmaster3.storage.searchurl.offline.data;

import org.joda.time.Instant;
import ru.yandex.webmaster3.storage.util.yt.YtPath;

import java.util.List;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class SearchBaseImportInfo {
    private final SearchBaseImportTaskType taskType;
    private final Instant searchBaseDate;
    private final String dbName;
    private final SearchBaseImportStageEnum stage;
    private final String readTableName;
    private final int shardsCount;
    private final int partsCount;
    private final String clickhouseDc;
    private final List<UUID> ytImportTaskIds;
    private final boolean paused;
    private final YtPath sourceTable;
    private final UUID importManagerTask;
    private final UUID replicationManagerTask;

    public SearchBaseImportInfo(SearchBaseImportTaskType taskType, Instant searchBaseDate, String dbName, SearchBaseImportStageEnum stage, String readTableName,
                                int shardsCount, int partsCount, String clickhouseDc, List<UUID> ytImportTaskIds, boolean paused, YtPath sourceTable, UUID importManagerTask, UUID replicationManagerTask) {
        this.taskType = taskType;
        this.searchBaseDate = searchBaseDate;
        this.dbName = dbName;
        this.stage = stage;
        this.readTableName = readTableName;
        this.shardsCount = shardsCount;
        this.partsCount = partsCount;
        this.clickhouseDc = clickhouseDc;
        this.ytImportTaskIds = ytImportTaskIds;
        this.paused = paused;
        this.sourceTable = sourceTable;
        this.importManagerTask = importManagerTask;
        this.replicationManagerTask = replicationManagerTask;
    }

    public boolean isPaused() {
        return paused;
    }

    public SearchBaseImportTaskType getTaskType() {
        return taskType;
    }

    public String getDbName() {
        return dbName;
    }

    public Instant getSearchBaseDate() {
        return searchBaseDate;
    }

    public SearchBaseImportStageEnum getStage() {
        return stage;
    }

    public String getReadTableName() {
        return readTableName;
    }

    public int getShardsCount() {
        return shardsCount;
    }

    public int getPartsCount() {
        return partsCount;
    }

    public String getClickhouseDc() {
        return clickhouseDc;
    }

    public List<UUID> getYtImportTaskIds() {
        return ytImportTaskIds;
    }

    public YtPath getSourceTable() {
        return sourceTable;
    }

    public UUID getImportManagerTask() {
        return importManagerTask;
    }

    public UUID getReplicationManagerTask() {
        return replicationManagerTask;
    }

    public SearchBaseImportInfo withStage(SearchBaseImportStageEnum stage) {
        return new SearchBaseImportInfo(taskType, searchBaseDate, dbName, stage, readTableName, shardsCount, partsCount, clickhouseDc, ytImportTaskIds, paused, sourceTable, importManagerTask, replicationManagerTask);
    }

    public SearchBaseImportInfo withSourceTable(YtPath sourceTable) {
        return new SearchBaseImportInfo(taskType, searchBaseDate, dbName, stage, readTableName, shardsCount, partsCount, clickhouseDc, ytImportTaskIds, paused, sourceTable, importManagerTask, replicationManagerTask);
    }

    public SearchBaseImportInfo withImportManagerTask(UUID importManagerTask){
        return new SearchBaseImportInfo(taskType, searchBaseDate, dbName, stage, readTableName, shardsCount, partsCount, clickhouseDc, ytImportTaskIds, paused, sourceTable, importManagerTask, replicationManagerTask);
    }

    public SearchBaseImportInfo withReplicationManagerTask(UUID replicationManagerTask){
        return new SearchBaseImportInfo(taskType, searchBaseDate, dbName, stage, readTableName, shardsCount, partsCount, clickhouseDc, ytImportTaskIds, paused, sourceTable, importManagerTask, replicationManagerTask);
    }

    @Override
    public String toString() {
        return "SearchBaseImportInfo{" +
                "taskType=" + taskType +
                ", searchBaseDate=" + searchBaseDate +
                ", dbName='" + dbName + '\'' +
                ", stage=" + stage +
                ", readTableName='" + readTableName + '\'' +
                ", shardsCount=" + shardsCount +
                ", partsCount=" + partsCount +
                ", clickhouseDc='" + clickhouseDc + '\'' +
                ", ytImportTaskIds=" + ytImportTaskIds +
                ", paused=" + paused +
                ", sourceTable=" + sourceTable +
                '}';
    }
}
