package ru.yandex.webmaster3.storage.searchurl.offline.data;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author avhaliullin
 */
public enum SearchBaseImportStageEnum {
    DISCOVERED(true),
    IMPORTING(true),
    IMPORTED(true),
    REPLICATED(true),
    READY(false),
    DELETING(false),
    DELETED(false),
    ;

    private final boolean toBeProcessed;

    SearchBaseImportStageEnum(boolean toBeProcessed) {
        this.toBeProcessed = toBeProcessed;
    }

    public boolean isToBeProcessed() {
        return toBeProcessed;
    }

    public static final EnumResolver<SearchBaseImportStageEnum> R = EnumResolver.er(SearchBaseImportStageEnum.class);
}
