package ru.yandex.webmaster3.storage.searchurl.offline.data;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author avhaliullin
 */
public enum SearchBaseImportTaskType {
    SEARCH_URL_SAMPLES("EXCLUDED_URL_SAMPLES"),
    SEARCH_URL_EVENT_SAMPLES("SEARCH_URL_EVENT_SAMPLES"),
    EXCLUDED_URL_SAMPLES("EXCLUDED_URL_SAMPLES"),
    SEARCH_URL_EMAIL_SAMPLES("SEARCH_URL_EMAIL_SAMPLES"),
    ;

    private final String prepareTaskName;

    SearchBaseImportTaskType(String prepareTaskName) {
        this.prepareTaskName = prepareTaskName;
    }

    public String getPrepareTaskName() {
        return prepareTaskName;
    }

    public static final EnumResolver<SearchBaseImportTaskType> R = EnumResolver.er(SearchBaseImportTaskType.class);
}
