package ru.yandex.webmaster3.storage.searchurl.samples;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.abt.AbtService;
import ru.yandex.webmaster3.storage.abt.model.Experiment;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.MemorandumSamplesCHDao;
import ru.yandex.webmaster3.storage.searchurl.samples.data.MemorandumSample;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;

/**
 * @author avhaliullin
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class MemorandumSamplesService {

    private final MemorandumSamplesCHDao mdbMemorandumSamplesCHDao;

    public long getSamplesCount(WebmasterHostId hostId, Condition filters) {
        return mdbMemorandumSamplesCHDao.getSamplesCount(hostId, filters);
    }

    public List<MemorandumSample> getSamples(WebmasterHostId hostId, Condition filters, long limitFrom, long limitSize) {
        return mdbMemorandumSamplesCHDao.getSamples(hostId, filters, limitFrom, limitSize);
    }
}
