package ru.yandex.webmaster3.storage.searchurl.samples.dao;

import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ru.yandex.webmaster3.core.util.TimeUtils;

/**
 * @author avhaliullin
 */
public class CommonSearchUrlSamplesTableUtil {
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern("yyyyMMddHHmmss");

    public static String distributedTableName(String baseTableName) {
        return baseTableName;
    }

    public static String partTablePrefix(String baseTableName) {
        return baseTableName + "_part";
    }

    public static String partTableName(String baseTableName, int part) {
        return partTablePrefix(baseTableName) + part;
    }

    public static String shardTableName(String baseTableName) {
        return baseTableName + "_shard";
    }

    public static String searchBaseName(Instant baseDate) {
        return baseDate.toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toString(FORMATTER);
    }
}
