package ru.yandex.webmaster3.storage.searchurl.samples.dao;

import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Operator;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.TimestampCondition;

/**
 * @author leonidrom
 */
public class ConditionUtils {
    public static Condition makeValidFromMetrikaCondition(AbstractFilter<?> filter, boolean isMetrikaCrawlEnabled, boolean isFresh) {
        if (filter.getOperation() != AbstractFilter.Operation.EQUAL) {
            throw filter.invalidFilterException();
        }

        int filterVal = Integer.parseInt(filter.getValue());
        if (filterVal == 1) {
            if (!isMetrikaCrawlEnabled || isFresh) {
                return Condition.falseCondition();
            }

            return new TimestampCondition(SearchUrlSamplesCHDao.F.EX_VALID_FROM_METRIKA_LAST_ACCESS.getName(), Operator.GREATER_THAN, 0);
        } else if (filterVal == 0) {
            if (isFresh) {
                return Condition.trueCondition();
            }

            return new TimestampCondition(SearchUrlSamplesCHDao.F.EX_VALID_FROM_METRIKA_LAST_ACCESS.getName(), Operator.EQUAL, 0);
        } else {
            throw filter.invalidFilterException();
        }
    }
}
