package ru.yandex.webmaster3.storage.searchurl.samples.dao;

import org.joda.time.Instant;

import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportInfo;

import static ru.yandex.webmaster3.storage.searchurl.samples.dao.CommonSearchUrlSamplesTableUtil.distributedTableName;
import static ru.yandex.webmaster3.storage.searchurl.samples.dao.CommonSearchUrlSamplesTableUtil.partTablePrefix;
import static ru.yandex.webmaster3.storage.searchurl.samples.dao.CommonSearchUrlSamplesTableUtil.searchBaseName;
import static ru.yandex.webmaster3.storage.searchurl.samples.dao.CommonSearchUrlSamplesTableUtil.shardTableName;

/**
 * @author avhaliullin
 */
public class ExcludedUrlSampleTablesUtil {
    public static final String DB_NAME = "webmaster3_searchurls";
    public static final String DISTRIB_SYMLINK_TABLE = "excluded_url_samples_distrib";

    public static final String EXCLUDED_TABLE_INSERT_SPEC = "(" +
            "host_id, " +
            "path, " +
            "last_access, " +
            "title, " +
            "status, " +
            "ex_region, " +
            "ex_add_time, " +
            "ex_beauty_url, " +
            "ex_http_code, " +
            "ex_main_host, " +
            "ex_main_path, " +
            "ex_main_region, " +
            "ex_redir_target, " +
            "ex_rel_canonical_target, " +
            "ex_is_fake, " +
            "ex_is_indexed, " +
            "ex_is_turbo, " +
            "ex_is_from_sitemap, " +
            "ex_is_searchable," +
            "ex_turbo_source_flags," +
            "ex_valid_from_metrika_last_access," +
            "ex_valid_from_indexnow_last_access" +
            ") FORMAT TabSeparated";

    public static final String EXCLUDED_TABLE_FIELDS_DECLARATION = "(" +
            "host_id String, " +
            "path String, " +
            "last_access Int64, " +
            "title String, " +
            "status Int8, " +
            "ex_region String, " +
            "ex_add_time Int64, " +
            "ex_beauty_url String, " +
            "ex_http_code Int32, " +
            "ex_main_host String, " +
            "ex_main_path String, " +
            "ex_main_region String, " +
            "ex_redir_target String, " +
            "ex_rel_canonical_target String, " +
            "ex_is_fake Int8, " +
            "ex_is_indexed Int8, " +
            "ex_is_turbo Int8, " +
            "ex_is_from_sitemap Int8, " +
            "ex_is_searchable Int8," +
            "ex_turbo_source_flags Int64," +
            "ex_valid_from_metrika_last_access Int64," +
            "ex_valid_from_indexnow_last_access Int64" +
            ")";

    private static String excludedBaseTableName(Instant baseDate) {
        return String.format("excluded_url_samples_%s", searchBaseName(baseDate));
    }

    private static String excludedUrlsPartTableNamePrefix(Instant baseDate) {
        return partTablePrefix(excludedBaseTableName(baseDate));
    }

    public static String excludedUrlsPartTableName(Instant baseDate, int part) {
        return excludedUrlsPartTableNamePrefix(baseDate) + part;
    }

    public static String excludedUrlsTableCreateSpec(Instant baseDate, int part) {
        return String.format(EXCLUDED_TABLE_FIELDS_DECLARATION +
                        " ENGINE = ReplicatedMergeTree('/webmaster3/clickhouse/tables/{shard}/excluded_url_samples_%s/part%d', '{replica}') " +
                        "PARTITION BY cityHash64(host_id) %% 16 ORDER BY (host_id, last_access)",
                searchBaseName(baseDate),
                part
        );
    }

    public static String excludedUrlsShardTableName(Instant baseDate) {
        return shardTableName(excludedBaseTableName(baseDate));
    }

    public static String excludedUrlsDistributedTableName(Instant baseDate) {
        return distributedTableName(excludedBaseTableName(baseDate));
    }

    public static String excludedUrlsShardCreateQuery(SearchBaseImportInfo info) {
        return "CREATE TABLE IF NOT EXISTS " + info.getDbName() + "." + excludedUrlsShardTableName(info.getSearchBaseDate()) + EXCLUDED_TABLE_FIELDS_DECLARATION +
                " ENGINE = Merge('" + info.getDbName() + "', '^" + excludedUrlsPartTableNamePrefix(info.getSearchBaseDate()) + "')";
    }

    public static String excludedUrlsDistributedCreateQuery(SearchBaseImportInfo info) {
        return "CREATE TABLE IF NOT EXISTS " + info.getDbName() + "." + excludedUrlsDistributedTableName(info.getSearchBaseDate()) + EXCLUDED_TABLE_FIELDS_DECLARATION +
                " ENGINE = Distributed('{cluster}', '" + info.getDbName() + "', '" + excludedUrlsShardTableName(info.getSearchBaseDate()) + "')";
    }

    public static String excludedUrlsDropSymlinkQuery() {
        return "DROP TABLE IF EXISTS " + DB_NAME + "." + DISTRIB_SYMLINK_TABLE;
    }

    public static String excludedUrlsCreateSymlinkQuery(SearchBaseImportInfo info) {
        return "CREATE TABLE IF NOT EXISTS " + info.getDbName() + "." + DISTRIB_SYMLINK_TABLE + EXCLUDED_TABLE_FIELDS_DECLARATION +
                " ENGINE = Distributed('{cluster}', '" + info.getDbName() + "', '" + excludedUrlsShardTableName(info.getSearchBaseDate()) + "')";
    }

}
