package ru.yandex.webmaster3.storage.searchurl.samples.dao;

import java.util.List;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.TextFilterUtil;
import ru.yandex.webmaster3.storage.searchurl.MemorandumField;
import ru.yandex.webmaster3.storage.util.StructureFilterService;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.TextLikeCondition;

/**
 * @author avhaliullin
 */
public class MemorandumConditions {
    public static Condition makeCondition(StructureFilterService structureFilterService, WebmasterHostId hostId, Long nodeId,
                                          List<? extends AbstractFilter<MemorandumField>> filters) {
        return makeCondition(filters)
                .andThen(structureFilterService.getNodeCondition(nodeId, hostId, SearchUrlConditions::buildPathCondition));
    }

    public static Condition makeCondition(List<? extends AbstractFilter<MemorandumField>> filters) {
        Condition condition = Condition.trueCondition();
        if (filters != null) {
            for (AbstractFilter<MemorandumField> filter : filters) {
                switch (filter.getIndicator()) {
                    case COPYRIGHT_OBJECT:
                        condition = condition.andThen(TextFilterUtil.getTextCondition(filter, getCopyrightObjectFieldName()));
                        break;
                    case COPYRIGHT_OWNER:
                        condition = condition.andThen(TextFilterUtil.getTextCondition(filter, getCopyrightOwnerFieldName()));
                        break;
                    case URL:
                        condition = condition.andThen(TextFilterUtil.getTextCondition(filter, getUrlFieldName()));
                        break;
                    default:
                        throw new RuntimeException("Not implemented filter for indicator " + filter.getIndicator());
                }
            }
        }
        return condition;
    }

    public static TextLikeCondition buildPathCondition(TextLikeCondition.Builder builder) {
        return builder.build(SearchUrlEventSamplesCHDao.F.PATH.getName());
    }

    public static String getCopyrightObjectFieldName() {
        return MemorandumSamplesCHDao.F.COPYRIGHT_OBJECT;
    }

    public static String getCopyrightOwnerFieldName() {
        return MemorandumSamplesCHDao.F.COPYRIGHT_OWNER;
    }

    public static String getUrlFieldName() {
        return MemorandumSamplesCHDao.F.PATH;
    }
}
