package ru.yandex.webmaster3.storage.searchurl.samples.dao;

import org.joda.time.Instant;
import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportInfo;

import static ru.yandex.webmaster3.storage.searchurl.samples.dao.CommonSearchUrlSamplesTableUtil.searchBaseName;
import static ru.yandex.webmaster3.storage.searchurl.samples.dao.CommonSearchUrlSamplesTableUtil.distributedTableName;
import static ru.yandex.webmaster3.storage.searchurl.samples.dao.CommonSearchUrlSamplesTableUtil.partTablePrefix;
import static ru.yandex.webmaster3.storage.searchurl.samples.dao.CommonSearchUrlSamplesTableUtil.shardTableName;

/**
 * @author avhaliullin
 */
public class SearchUrlSampleTablesUtil {
    public static final String DB_NAME = "webmaster3_searchurls";
    public static final String DISTRIB_SYMLINK_TABLE = "search_url_samples_distrib";

    public static final String URL_TABLE_INSERT_SPEC = ExcludedUrlSampleTablesUtil.EXCLUDED_TABLE_INSERT_SPEC;

    private static final String URL_TABLE_FIELDS_DECLARATION = ExcludedUrlSampleTablesUtil.EXCLUDED_TABLE_FIELDS_DECLARATION;

    private static String urlsBaseTableName(Instant baseDate) {
        return String.format("search_url_samples_%s", searchBaseName(baseDate));
    }

    private static String urlsPartTableNamePrefix(Instant baseDate) {
        return partTablePrefix(urlsBaseTableName(baseDate));
    }

    public static String urlsPartTableName(Instant baseDate, int part) {
        return urlsPartTableNamePrefix(baseDate) + part;
    }

    public static String urlsTableCreateSpec(Instant baseDate, int part) {
        return String.format(URL_TABLE_FIELDS_DECLARATION +
                        " ENGINE = ReplicatedMergeTree('/webmaster3/clickhouse/tables/{shard}/search_url_samples_%s/part%d', '{replica}') " +
                        "PARTITION BY cityHash64(host_id) %% 16 ORDER BY (host_id, last_access)",
                searchBaseName(baseDate),
                part
        );
    }

    public static String urlsShardTableName(Instant baseDate) {
        return shardTableName(urlsBaseTableName(baseDate));
    }

    public static String urlsDistributedTableName(Instant baseDate) {
        return distributedTableName(urlsBaseTableName(baseDate));
    }

    public static String urlsShardCreateQuery(SearchBaseImportInfo info) {
        return "CREATE TABLE IF NOT EXISTS " + info.getDbName() + "." + urlsShardTableName(info.getSearchBaseDate()) + URL_TABLE_FIELDS_DECLARATION +
                " ENGINE = Merge('" + info.getDbName() + "', '^" + urlsPartTableNamePrefix(info.getSearchBaseDate()) + "')";
    }

    public static String urlsDistributedCreateQuery(SearchBaseImportInfo info) {
        return "CREATE TABLE IF NOT EXISTS " + info.getDbName() + "." + urlsDistributedTableName(info.getSearchBaseDate()) + URL_TABLE_FIELDS_DECLARATION +
                " ENGINE = Distributed('{cluster}', '" + info.getDbName() + "', '" + urlsShardTableName(info.getSearchBaseDate()) + "')";
    }

    public static String urlsDropSymlinkQuery() {
        return "DROP TABLE IF EXISTS " + DB_NAME + "." + DISTRIB_SYMLINK_TABLE;
    }

    public static String urlsCreateSymlinkQuery(SearchBaseImportInfo info) {
        return "CREATE TABLE IF NOT EXISTS " + info.getDbName() + "." + DISTRIB_SYMLINK_TABLE + URL_TABLE_FIELDS_DECLARATION +
                " ENGINE = Distributed('{cluster}', '" + info.getDbName() + "', '" + urlsShardTableName(info.getSearchBaseDate()) + "')";
    }
}
