package ru.yandex.webmaster3.storage.searchurl.samples.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import lombok.With;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

@Value
@With
public class BadUrlSample {
    WebmasterHostId hostId;
    String url;
    long httpCode;
    long lastAccess;

    @JsonCreator
    public BadUrlSample(@JsonProperty("hostId") WebmasterHostId hostId,
                        @JsonProperty("url") String url,
                        @JsonProperty("httpCode") long httpCode,
                        @JsonProperty("lastAccess") long lastAccess) {
        this.hostId = hostId;
        this.url = url;
        this.httpCode = httpCode;
        this.lastAccess = lastAccess;
    }

    public static BadUrlSample of(String url, long hourInterval, long httpCode, long lastAccess) {
        return new BadUrlSample(IdUtils.urlToHostId(url), url, httpCode, lastAccess);
    }
}
