package ru.yandex.webmaster3.storage.searchurl.samples.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.TimeUtils;

/**
 * @author avhaliullin
 */
public class ExcludedUrlSample {
    private final String path;
    private final String url;
    private final String title;
    private final DateTime lastAccess;
    private final UrlStatusInfo statusInfo;

    // Есть подозрение, что Json deserialization этого класса никто на самом деле не использует
    public ExcludedUrlSample(@JsonProperty("path") String path,
                             @JsonProperty("url") String url,
                             @JsonProperty("title") String title,
                             @JsonProperty("lastAccess") LocalDate lastAccess,
                             @JsonProperty("statusInfo") UrlStatusInfo statusInfo) {

        this(path, url, title, lastAccess == null? null: lastAccess.toDateTimeAtStartOfDay(TimeUtils.EUROPE_MOSCOW_ZONE),
                statusInfo);
    }

    public ExcludedUrlSample(String path, String url, String title, DateTime lastAccess, UrlStatusInfo statusInfo) {
        this.path = path;
        this.url = url;
        this.title = title;
        this.lastAccess = lastAccess;
        this.statusInfo = statusInfo;
    }


    @Description("относительный адрес страницы (без хоста)")
    public String getPath() {
        return path;
    }

    @Description("адрес страницы")
    public String getUrl() {
        return url;
    }

    @Description("заголовок страницы")
    public String getTitle() {
        return title;
    }

    @Description("дата последнего посещения страницы")
    // фронтенд хочет видеть данные в виде LocalDate
    public LocalDate getLastAccess() {
        return lastAccess == null? null: lastAccess.toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toLocalDate();
    }

    @Description("информация о статусе исключенной страницы")
    public UrlStatusInfo getStatusInfo() {
        return statusInfo;
    }

    @JsonIgnore
    public DateTime getLastAccessDateTime() {
        return lastAccess;
    }
}
