package ru.yandex.webmaster3.storage.searchurl.samples.data;

import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/**
 * @author avhaliullin
 */
public class RawSearchUrlEventSample {
    private final String url;
    private final String title;
    @Nullable
    private final DateTime lastAccess;
    @Nullable
    private final DateTime searchBaseCollectDate;
    private final SearchUrlEventType eventType;
    private final RawUrlStatusInfo statusInfo;

    public RawSearchUrlEventSample(String url, String title, @Nullable DateTime lastAccess, @Nullable DateTime searchBaseCollectDate,
                                   SearchUrlEventType eventType, RawUrlStatusInfo statusInfo) {
        this.url = url;
        this.title = title;
        this.lastAccess = lastAccess;
        this.searchBaseCollectDate = searchBaseCollectDate;
        this.eventType = eventType;
        this.statusInfo = statusInfo;
    }

    public String getUrl() {
        return url;
    }

    public String getTitle() {
        return title;
    }

    @Nullable
    public DateTime getLastAccess() {
        return lastAccess;
    }

    @Nullable
    public DateTime getSearchBaseCollectDate() {
        return searchBaseCollectDate;
    }

    public SearchUrlEventType getEventType() {
        return eventType;
    }

    public RawUrlStatusInfo getStatusInfo() {
        return statusInfo;
    }
}
