package ru.yandex.webmaster3.storage.searchurl.samples.data;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class RawSearchUrlEventSampleWithHost extends RawSearchUrlEventSample {
    private final WebmasterHostId hostId;

    public RawSearchUrlEventSampleWithHost(String url, String title, DateTime lastAccess,
            DateTime searchBaseCollectDate,
            SearchUrlEventType eventType, RawUrlStatusInfo statusInfo, WebmasterHostId hostId)
    {
        super(url, title, lastAccess, searchBaseCollectDate, eventType, statusInfo);
        this.hostId = hostId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }
}
