package ru.yandex.webmaster3.storage.searchurl.samples.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class RawSearchUrlSample {
    private final String url;
    private final String title;
    private final DateTime lastAccess;
    private final RawUrlStatusInfo statusInfo;

    public RawSearchUrlSample(String url, String title, DateTime lastAccess, RawUrlStatusInfo statusInfo) {
        this.url = url;
        this.title = title;
        this.lastAccess = lastAccess;
        this.statusInfo = statusInfo;
    }

    public String getUrl() {
        return url;
    }

    public String getTitle() {
        return title;
    }

    public DateTime getLastAccess() {
        return lastAccess;
    }

    public RawUrlStatusInfo getStatusInfo() {
        return statusInfo;
    }
}
